#define WIN32_LEAN_AND_MEAN

#include <windows.h>
#include <gl/gl.h>
#include <gl/glu.h>
#include <mmsystem.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "ljud.h"



//--------------------------------+
//     WINDOWS-VARIABLAR          |
//--------------------------------+

HDC hDC;
HGLRC hglrc; 
float t;



//--------------------------------+
//     OPENGL-VARIABLAR           |
//--------------------------------+

GLUquadricObj *quadratic;


//--------------------------------+
//     LJUD-VARIABLAR             |
//--------------------------------+

HWAVEOUT	waveOutHandle;
WAVEHDR		waveHdr;
WAVEFORMATEX	pcmwf;
int lastBufferRendered = 0;

volatile bool		exitFromThread = false;
volatile bool		threadFinished = false;
volatile HANDLE		threadHandle;



//--------------------------------+
//		ljud_outputSound_thread() |
//--------------------------------+
_inline void ljud_outputSound_thread(LPDWORD lpdwParam){
	
	int lastBufferRendered = 0;
	
	while (exitFromThread == false){
		
		MMTIME	mmt;
		mmt.wType = TIME_BYTES;
		waveOutGetPosition(waveOutHandle, &mmt, sizeof(MMTIME));
		int cursorPos = mmt.u.cb / 4;
		cursorPos %= (numBuffers*bufferSize);
		int cursorBuffer = cursorPos / bufferSize;
		int prevBuffer   = cursorBuffer - 1;
		
		if (prevBuffer < 0)
			prevBuffer = numBuffers - 1;
		
		if (lastBufferRendered != prevBuffer)
		{
			ljud_fillBuffer(prevBuffer);
			lastBufferRendered = prevBuffer;
		}
		Sleep(5);
	};
	
}




void bolltjofs(void)
{
	for(int mojs=0;mojs<5;mojs++)
	{
		glRotatef(72,0,1,0);
		glPushMatrix();
		glTranslatef(0,0,-8);
		gluSphere(quadratic,3,10,10);
		glPopMatrix();
	}
	

	for (int uppe_och_nere=-1;uppe_och_nere<2;uppe_och_nere+=2)
	{
		for(int	bice=0;bice<3;bice++)
		{
			glRotatef(120,0,1,0);
			glPushMatrix();
			glTranslatef(0,6*uppe_och_nere,-6);
			gluSphere(quadratic,3,10,10);
			glPopMatrix();
		}
	}
}




int main()
{ 

//---------------------------------------------------------------------------------

	//----------------------------------------
	//		WINDOW INIT
	//----------------------------------------

	DEVMODE dmScreenSettings;							
	dmScreenSettings.dmSize=sizeof(dmScreenSettings);	
	dmScreenSettings.dmPelsWidth	= 800;			
	dmScreenSettings.dmPelsHeight	= 600;			
	dmScreenSettings.dmBitsPerPel	= 32;			
	dmScreenSettings.dmFields=DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT;
	if (ChangeDisplaySettings(&dmScreenSettings,CDS_FULLSCREEN)!=DISP_CHANGE_SUCCESSFUL)
		return false;

	HWND window;
//	window = CreateWindowEx(WS_EX_TOPMOST,"STATIC","STATIC",WS_VISIBLE+WS_POPUP,0,0, GetSystemMetrics(SM_CXSCREEN),GetSystemMetrics(SM_CYSCREEN),0,0,0,0);
	window = CreateWindowEx(WS_EX_TOPMOST,"STATIC","STATIC",WS_VISIBLE+WS_POPUP,0,0, 800,600,0,0,0,0);
	hDC = GetDC(window);
	SetPixelFormat(hDC,4,0);
	hglrc = wglCreateContext(hDC); 
	wglMakeCurrent(hDC,hglrc);
	ShowCursor(FALSE);
//---------------------------------------------------------------------------------



//---------------------------------------------------------------------------------

	//----------------------------------------
	//		OPENGL INIT
	//----------------------------------------

	glMatrixMode(GL_PROJECTION);
	gluPerspective(90,1.33,1,2000);	
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	
	glClearColor(0.1f, 0.1f, 0.3f, 0.5f);	
	
	GLfloat LightAmbient[]=		{ 0.1f, 0.1f, 0.1f, 1 };
	GLfloat LightDiffuse[]=		{ 0.5f, 0.5f, 0.5f, 1 };
	GLfloat LightPosition1[]=	{ -10,  -10, 20, 1 };
	glLightfv(GL_LIGHT1, GL_AMBIENT, LightAmbient);
	glLightfv(GL_LIGHT1, GL_DIFFUSE, LightDiffuse);		
	glLightfv(GL_LIGHT1, GL_POSITION,LightPosition1);	

	glEnable(GL_LIGHT1);								
	glEnable(GL_LIGHTING);
	glEnable(GL_COLOR_MATERIAL);						

	glEnable(GL_BLEND);
	glEnable(GL_DEPTH_TEST);						
	
	glCullFace(GL_BACK);								// Set Culling Face To Back Face

	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glShadeModel(GL_FLAT);
	
	quadratic = gluNewQuadric();
	gluQuadricTexture(quadratic,GL_TRUE);

	GLfloat fogColor[4]= {1, 0.0f, 0.0f, 1};		// Fog Color
	glFogfv(GL_FOG_COLOR, fogColor);		// Set Fog Color
	glFogi(GL_FOG_MODE, GL_LINEAR );		// Fog Mode
	glFogf(GL_FOG_DENSITY, 2);				// How Dense Will The Fog Be
	glFogf(GL_FOG_START, 30);				// Fog Start Depth
	glFogf(GL_FOG_END, 40);					// Fog End Depth
	glHint(GL_FOG, GL_FASTEST);
	gluBuild2DMipmaps(GL_TEXTURE_2D,4,16,16,GL_RGBA,GL_UNSIGNED_BYTE,&main);

//---------------------------------------------------------------------------------



//---------------------------------------------------------------------------------

	//----------------------------------------
	//		WAVEOUT INIT
	//----------------------------------------

	pcmwf.wFormatTag		= WAVE_FORMAT_PCM;
	pcmwf.nChannels			= 2;
	pcmwf.wBitsPerSample	= 16;
	pcmwf.nBlockAlign		= pcmwf.nChannels * pcmwf.wBitsPerSample / 8;
	pcmwf.nSamplesPerSec	= mixRate;
	pcmwf.nAvgBytesPerSec	= pcmwf.nSamplesPerSec * pcmwf.nBlockAlign;
	waveOutOpen(&waveOutHandle, WAVE_MAPPER, &pcmwf, 0, 0, 0);

	#define length  24576 //numBuffers*bufferSize*2;  // 4096*3*2		//	3 buffers
	mixBuffer = new short[length];

	waveHdr.dwFlags			= WHDR_BEGINLOOP | WHDR_ENDLOOP;
	waveHdr.lpData			= (LPSTR) mixBuffer;
	waveHdr.dwBufferLength	= 2*length;
	waveHdr.dwLoops			= -1;
	waveOutPrepareHeader(waveOutHandle, &waveHdr, sizeof(WAVEHDR));
	
	waveOutWrite(waveOutHandle, &waveHdr, sizeof(WAVEHDR));






	{
		DWORD	threadId;
		threadHandle = CreateThread(NULL, 0,
			(LPTHREAD_START_ROUTINE) ljud_outputSound_thread,
			0,0, &threadId);
		SetThreadPriority(threadHandle, THREAD_PRIORITY_NORMAL);
	}









//---------------------------------------------------------------------------------








//---------------------------------------------------------------------------------

	//----------------------------------------
	//		DA INTRO
	//----------------------------------------

	float startclock = timeGetTime();				// initera programmets klocka


	while(!GetAsyncKeyState(VK_ESCAPE))
	{
		float tid;				// denna hller tiden i millisekunder och kallas av ALLT
		float lasttime;
		float lastframe;


		tid = (timeGetTime() - startclock);			// hur mnga millisekunder har gtt sedan "startclock"?
		lastframe = tid - lasttime;						// hur mnga millisekunder tog frra framen?
		lasttime = tid;										// anvnds till fregende.


/*		MMTIME	mmt;
		mmt.wType = TIME_BYTES;
		waveOutGetPosition(waveOutHandle, &mmt, sizeof(MMTIME));
		int cursorPos = (mmt.u.cb / 4);
		cursorPos %= (numBuffers*bufferSize);
		int cursorBuffer = cursorPos / bufferSize;
		int prevBuffer   = cursorBuffer - 1;
		
		if (prevBuffer < 0)
			prevBuffer = numBuffers - 1;
		
		if (lastBufferRendered != prevBuffer)
		{
			ljud_fillBuffer(prevBuffer);
			lastBufferRendered = prevBuffer;
		}
*/

		#define  FLIP 20000
		t+= lastframe*0.02;

		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);




		if (tid<FLIP)
		{	
			glEnable(GL_FOG);

			for(int z=5; z<60; z+=4)
			{
				for(int x=-60; x<60; x+=4)
				{
					glColor3f(0.65-(z*0.006),0.65-(z*0.006),0.02*sync+0.85-(z*0.006));
					glLoadIdentity();

					if (tid<7500)
					{
						glRotatef(35,1,0,0);
						glTranslatef(0,0,5);
					}
					else if (tid>15000)
					{
						glDisable(GL_FOG);
						glRotatef(50-(float(tid)-15000)/50,1,0,0);
						glRotatef(-35+sin(float(tid)/2000)*15,0,1,0);
						glTranslatef(-40,5,10);
					}
					else
					{
						glRotatef(50,1,0,0);
						glRotatef(-35+sin(float(tid)/2000)*15,0,1,0);
						glTranslatef(-40,5,10);
					}

					glTranslatef(x, -10 +  sync + sin(0.05*t + z*0.25)   +    sin(x*0.25 + 0.035*t),-z);
					glRotatef(90,1,0,0);
					glRotatef(t,0,0,1);

					glEnable(GL_CULL_FACE);
					gluCylinder(quadratic,2,2,100,5,1);
					glDisable(GL_CULL_FACE);
					gluDisk(quadratic,0,2,5,1);

				}

			}			
			glDisable(GL_FOG);

		}

		else if (tid > 60000)
		{
			return;
		}

		else
		{	
			glShadeModel(GL_SMOOTH);
			glEnable(GL_CULL_FACE);
			glColor3f(0.6,0.6,0.9);
			glLoadIdentity();

			

			if (tid > 35000)
			{		
				glTranslatef(0,10,-140+sync*10);
				glRotatef(t,1,2,0);					
				
				for (int i=-50; i<50; i+=10)
					for (int j=-50; j<50; j+=10)
						for (int k=-50; k<50; k+=10)	
						{	
							glPushMatrix();
							float bice = 2*sin((i*k+j+t)*0.5);
							glTranslatef(i,j,k);
							gluSphere(quadratic,3+bice,5,5);
							glPopMatrix();
						}	
			}

			else
			{
				t+=sync*5;


				glTranslatef(sin(t*0.02)*40,sin(t*0.04)*20,-60);
				glRotatef(t,0,1,2);					

				for (int mojs=1;mojs<2;mojs++)
				{



					glScalef(1+sync*0.2,1+sync*0.2,1+sync*0.2);

					for(int mojs=0;mojs<5;mojs++)
					{
						
						glRotatef(72,0,1,0);
						glPushMatrix();
						glTranslatef(0,0,-21);
						gluSphere(quadratic,7,10,10);
						bolltjofs();
						glPopMatrix();
					}

					for (int uppe_och_nere=-1;uppe_och_nere<2;uppe_och_nere+=2)
					{			
						for(int	bice=0;bice<3;bice++)
						{
							glRotatef(120,0,1,0);
							glPushMatrix();
							glTranslatef(0,17*uppe_och_nere,-14);
							gluSphere(quadratic,7,10,10);
							bolltjofs();
							glPopMatrix();
						}
					}	
					gluSphere(quadratic,20,15,15);
				}
			}
			glDisable(GL_CULL_FACE);
		}

		glColor3f(0.2,0.2,0.6);
		glLoadIdentity();
		glEnable(GL_TEXTURE_2D);
		glRotatef(t,0,1,0);

		glRotatef(90,1,0,0);
		gluSphere(quadratic,240,10,10);		

		glRotatef(t,1,0,0);
		gluSphere(quadratic,220,10,10);

		glDisable(GL_TEXTURE_2D);
		sync = sync/1.5;


		SwapBuffers(hDC);

	}


	gluDeleteQuadric(quadratic);
	ShowCursor(TRUE);
	wglMakeCurrent(0,0);
	wglDeleteContext(hglrc); 
}



